unit Refer1C;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Config1C;

type
  TReference1C = class(TComponent1C)
  private
    FObj: Variant;
    FObjName: String;
    procedure SetObjName(const AValue: String);
    //   1-
    function CreateObj: Variant;
    // get-  set-
    function GetAttributesValue(const AAttributeName: String): Variant;
    procedure SetAttributesValue(const AAttributeName: String;
      const AValue: Variant);
  protected
    //    - 
    //   /  OLE-
    //      !
    procedure ConnectEvent; override;
  public
    // 
    constructor Create(AOwner: TComponent); override;
    //    1- (IDispatch)
    property Obj: Variant read FObj;
    //  property,    
    //   ,  "Reference.Obj."
    //   "Reference['']"
    property Attributes[const AttributeName: String]: Variant
      read GetAttributesValue write SetAttributesValue; default;
    //   1-
    // ()
    function Kind: String;
    // ()
    function UserKind: String;
    // ()
    function Level: Integer;
    // (<>,<>)
    procedure SetAttribute(AAttributeName: String; AValue: Variant);
    // (<>)
    function GetAttribute(AAttributeName: String): Variant;
    // ()
    function IsGroup: Boolean;
    // (<>)
    function BelongsToGroup(AGroup: Variant): Boolean;
    // ()
    function Selected: Boolean;
    // ()
    function CurrentItem: Variant;
    // ()
    function FullCode: String;
    // ()
    function FullDescr: String;
    // *(<>)
    function FindItem(AItem: Variant): Boolean;
    // *(<>,<>)
    function FindByCode(ACode: Variant; AFindFlag: Variant): Boolean;
    // *(<>,<>,<>)
    function FindByDescr(ADescr: String; ARegime,
      AFindFlag: Variant): Boolean;
    // *(<>,<>,<>)
    function FindByAttribute(AAttributeName: String; AValue,
      AFindFlag: Variant): Boolean;
    // (<>)
    function SelectItems(ARegime: Variant): Boolean;
    // *(<>,<>,
    //   <>,<>)
    function SelectItemsByAttribute(AAttributeName: String; AValue,
      ARegimeI, ARegimeG: Variant): Boolean;
    // (<>)
    function BackwardOrder(ARegime: Variant): Boolean;
    // (<>)
    function GetItem(ARegime: Variant): Boolean;
    // *(<>,<>)
    function UseDate(ADate, ARegime: Variant): Variant;
    // *(<>,<>)
    function UseOwner(AOwner: Variant): Variant;
    // *(<>,<>)
    function UseParent(AParent: Variant): Variant;
    // (<>)
    function IncludeChildren(ARegime: Variant): Boolean;
    // ()
    procedure OrderByCode;
    // ()
    procedure OrderByDescr;
    // (<>)
    procedure OrderByAttribute(AAttributeName: String);
    // ()
    procedure New;
    // ()
    procedure NewGroup;
    // *(<>)
    function CodePrefix(APrefix: String): String;
    // *(<>)
    procedure SetNewCode(APrefix: String);
    // *(<>,<>,<>,<>)
    procedure SetType(AAttributeName: String; ATypeName: String;
      ALength: Variant; APrecision: Variant);
    // ()
    procedure Write;
    // (<>)
    procedure Delete(ARegime: Variant);
    // ()
    procedure ClearDeleteMark;
    // ()
    function DeleteMark: Boolean;
  published
    //   (     )
    property ObjName: String read FObjName write SetObjName;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('1C Servers', [TReference1C]);
end;

{ TReference1C }

// (<>)
function TReference1C.BackwardOrder(ARegime: Variant): Boolean;
begin
  Result := Boolean(FObj.(OleVariant(ARegime)));
end;

// (<>)
function TReference1C.BelongsToGroup(AGroup: Variant): Boolean;
begin
  Result := Boolean(FObj.(OleVariant(AGroup)));
end;

// ()
procedure TReference1C.ClearDeleteMark;
begin
  FObj.(Unassigned);
end;

// (<>)
function TReference1C.CodePrefix(APrefix: String): String;
begin
  Result := FObj.(OleVariant(APrefix));
end;

//    - 
//   /  OLE-
//      !
procedure TReference1C.ConnectEvent;
begin
  //     
  if Assigned(Configuration) and Configuration.Connected then begin
    // ...    ,   
    if VarIsEmpty(FObj) then
      FObj := CreateObj;
  end else begin
    //  - 
    FObj := Unassigned;
  end;
end;

// 
constructor TReference1C.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  //  properties
  FObj := Unassigned;
  FObjName := '';
end;

//   1-
function TReference1C.CreateObj: Variant;
var
  FullObjName: String;
begin
  try
    FullObjName := '';
    if ObjName <> '' then
      FullObjName := FullObjName + '.' + ObjName;
    Result := Configuration.CreateObject(FullObjName);
  except
    MessageDlg('    "' + FullObjName + '"!',
      mtError, [mbOK], 0);
  end;
end;

// ()
function TReference1C.CurrentItem: Variant;
begin
  Result := FObj.(Unassigned);
end;

// (<>)
procedure TReference1C.Delete(ARegime: Variant);
begin
  FObj.(OleVariant(ARegime));
end;

// ()
function TReference1C.DeleteMark: Boolean;
begin
  Result := Boolean(FObj.(Unassigned));
end;

// (<>,<>,<>)
function TReference1C.FindByAttribute(AAttributeName: String; AValue,
  AFindFlag: Variant): Boolean;
begin
  Result := Boolean(FObj.(OleVariant(AAttributeName),
    OleVariant(AValue), OleVariant(AFindFlag)));
end;

// (<>,<>)
function TReference1C.FindByCode(ACode: Variant;
  AFindFlag: Variant): Boolean;
begin
  Result := Boolean(FObj.(OleVariant(ACode),
    OleVariant(AFindFlag)));
end;

// (<>,<>,<>)
function TReference1C.FindByDescr(ADescr: String; ARegime,
  AFindFlag: Variant): Boolean;
begin
  Result := Boolean(FObj.(OleVariant(ADescr),
    OleVariant(ARegime), OleVariant(AFindFlag)));
end;

// (<>)
function TReference1C.FindItem(AItem: Variant): Boolean;
begin
  Result := Boolean(FObj.(OleVariant(AItem)));
end;

// ()
function TReference1C.FullCode: String;
begin
  Result := FObj.(Unassigned);
end;

// ()
function TReference1C.FullDescr: String;
begin
  Result := FObj.(Unassigned);
end;

// (<>)
function TReference1C.GetAttribute(AAttributeName: String): Variant;
begin
  Result := FObj.(OleVariant(AAttributeName));
end;

function TReference1C.GetAttributesValue(const AAttributeName: String): Variant;
begin
  Result := FObj.(OleVariant(AAttributeName));
end;

// (<>)
function TReference1C.GetItem(ARegime: Variant): Boolean;
begin
  Result := Boolean(FObj.(OleVariant(ARegime)));
end;

// (<>)
function TReference1C.IncludeChildren(ARegime: Variant): Boolean;
begin
  Result := Boolean(FObj.(ARegime));
end;

// ()
function TReference1C.IsGroup: Boolean;
begin
  Result := Boolean(FObj.(Unassigned));
end;

// ()
function TReference1C.Kind: String;
begin
  Result := FObj.(Unassigned);
end;

// ()
function TReference1C.Level: Integer;
begin
  Result := FObj.(Unassigned);
end;

// ()
procedure TReference1C.New;
begin
  FObj.(Unassigned);
end;

// ()
procedure TReference1C.NewGroup;
begin
  FObj.(Unassigned);
end;

// (<>)
procedure TReference1C.OrderByAttribute(AAttributeName: String);
begin
  FObj.(OleVariant(AAttributeName));
end;

// ()
procedure TReference1C.OrderByCode;
begin
  FObj.(Unassigned);
end;

// ()
procedure TReference1C.OrderByDescr;
begin
  FObj.(Unassigned);
end;

// ()
function TReference1C.Selected: Boolean;
begin
  Result := Boolean(FObj.(Unassigned));
end;

// (<>)
function TReference1C.SelectItems(ARegime: Variant): Boolean;
begin
  Result := Boolean(FObj.(OleVariant(ARegime)));
end;

// (<>,<>,
//   <>,<>)
function TReference1C.SelectItemsByAttribute(AAttributeName: String;
  AValue, ARegimeI, ARegimeG: Variant): Boolean;
begin
  Result := Boolean(FObj.(
    OleVariant(AAttributeName), OleVariant(AValue),
    OleVariant(ARegimeI), OleVariant(ARegimeG)));
end;

// (<>,<>)
procedure TReference1C.SetAttribute(AAttributeName: String;
  AValue: Variant);
begin
  FObj.(OleVariant(AAttributeName),
    OleVariant(AValue));
end;

procedure TReference1C.SetAttributesValue(const AAttributeName: String;
  const AValue: Variant);
begin
  FObj.(OleVariant(AAttributeName),
    OleVariant(AValue));
end;

// (<>)
procedure TReference1C.SetNewCode(APrefix: String);
begin
  FObj.(OleVariant(APrefix));
end;

procedure TReference1C.SetObjName(const AValue: String);
begin
  if FObjName <> AValue then begin
    FObjName := AValue;
    //     
    if Assigned(Configuration) and Configuration.Connected then
      //   
      FObj := CreateObj
    else
      //  - 
      FObj := Unassigned;
  end;
end;

// (<>,<>,<>,<>)
procedure TReference1C.SetType(AAttributeName, ATypeName: String; ALength,
  APrecision: Variant);
begin
  FObj.(OleVariant(AAttributeName),
    OleVariant(ATypeName), OleVariant(ALength),
    OleVariant(APrecision));
end;

// (<>,<>)
function TReference1C.UseDate(ADate, ARegime: Variant): Variant;
begin
  Result := FObj.(OleVariant(ADate),
    OleVariant(ARegime));
end;

// (<>,<>)
function TReference1C.UseOwner(AOwner: Variant): Variant;
begin
  Result := FObj.(OleVariant(AOwner),
    OleVariant(Unassigned));
end;

// (<>,<>)
function TReference1C.UseParent(AParent: Variant): Variant;
begin
  Result := FObj.(OleVariant(AParent),
    OleVariant(Unassigned));
end;

// ()
function TReference1C.UserKind: String;
begin
  Result := FObj.(Unassigned);
end;

// ()
procedure TReference1C.Write;
begin
  FObj.(Unassigned);
end;

end.
