unit Docum1C;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, Config1C;

type
  TDocument1C = class(TComponent1C)
  private
    FObj: Variant;
    FObjName: String;
    //   1-
    function CreateObj: Variant;
    // get-  set-
    procedure SetObjName(const AValue: String);
    function GetAttributesValue(const AAttributeName: String): Variant;
    procedure SetAttributesValue(const AAttributeName: String;
      const AValue: Variant);
  protected
    //    - 
    //   /  OLE-
    //      !
    procedure ConnectEvent; override;
  public
    // 
    constructor Create(AOwner: TComponent); override;
    //    1- (IDispatch)
    property Obj: Variant read FObj;
    //  property,    
    //   ,  "Document.Obj."
    //   "Document['']"
    property Attributes[const AttributeName: String]: Variant
      read GetAttributesValue write SetAttributesValue; default;
    //   1-
    // ()
    function Kind: String;
    // ()
    function UserKind: String;
    // (<>,<>)
    procedure SetAttribute(AAttributeName: String; AValue: Variant);
    // (<>)
    function GetAttribute(AAttributeName: String): Variant;
    // ()
    function Selected: Boolean;
    // ()
    function IsTransacted: Boolean;
    // ()
    function CurrentDocument: Variant;
    // (<>)
    function Total(AAttributeName: String): Double;
    // ()
    function LinesCnt: Integer;
    // (<>)
    function FindDocument(ADocument: Variant): Boolean;
    // (<>,<>,<>)
    function FindByNum(ANum: Variant; ADate: Variant;
      AKindName: Variant): Boolean;
    // (<>)
    function GetLineByNum(ANum: Integer): Boolean;
    // (<1>,<2>)
    function SelectDocuments(ADate1: Variant;
      ADate2: Variant): Boolean;
    // (<1>,<2>,<>)
    function SelectChildDocs(ADate1: Variant;
      ADate2: Variant; ADocument: Variant): Boolean;
    // (<1>,<2>,<>,<>)
    function SelectByValue(ADate1: Variant; ADate2: Variant;
      ASelectionName: String; AValue: Variant): Boolean;
    // (<>,<>,<>)
    function SelectByNum(ANum: Variant; ADate: Variant;
      AKindName: Variant): Boolean;
    // *(<1>,<2>,<>)
    function SelectBySucc(ADate1: Variant; ADate2: Variant;
      ASuccName: String): Boolean;
    // (<>)
    function BackwardOrder(ARegime: Variant): Boolean;
    // *(<>,<>,
    //   <>,<>,<>,<>)
    function SetFilter(ATransacted: Integer; ANoTransacted: Integer;
      AWithoutSigns: Integer; AOperative: Integer;
      ACalculate: Integer; ABookKeeping: Integer): Boolean;
    // ()
    function GetDocument: Boolean;
    // ()
    function SelectLines: Boolean;
    // ()
    function GetLine: Boolean;
    // *()
    procedure New;
    // *(<>)
    function NumPrefix(APrefix: String): String;
    // *(<>)
    procedure SetNewNum(APrefix: String);
    // *(<>,<>,<>,<>)
    procedure SetType(AAttributeName: String; ATypeName: String;
      ALength: Variant; APrecision: Variant);
    // *()
    procedure Write;
    // *(<>)
    procedure Delete(ARegime: Variant);
    // *()
    procedure ClearDeleteMark;
    // *()
    function DeleteMark: Boolean;
    // *()
    procedure NewLine;
    // *()
    procedure DeleteLine;
    // *()
    procedure DeleteLines;
    // (<>)
    procedure SortLines(AColumns: String);
    // *(<>,<>,<>)
    procedure SetTime(AHour: Integer; AMin: Integer; ASec: Integer);
    // (<>,<>,<>)
    function GetTime(var AHour: Integer; var AMin: Integer;
      var ASec: Integer): String;
    // *()
    function GetPosition: Variant;
    // *()
    procedure AutoTimeBegOfDay;
    // *()
    procedure AutoTimeEndOfDay;
    // *()
    procedure AutoTimeCurrent;
    // *()
    procedure AutoTimeOff;
    // *()
    procedure AutoTimeAfterAP;
    // (<>,<>)
    procedure MakeActions(ARegime: Variant; AValue: Variant);
    // ()
    procedure UnPost;
    // *()
    function CompareWithAP: Integer;
    // *(<>)
    function OperExist(AExist: Variant): Boolean;
  published
    //   (     )
    property ObjName: String read FObjName write SetObjName;
  end;

const
  //    (. SetFilter())
  NOT_INCLUDE_IN = 0;     //    
  INCLUDE_IN = 1;         //   
  INCLUDE_IN_ONLY_IF = 2; //   ,   

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('1C Servers', [TDocument1C]);
end;

{ TDocument1C }

// ()
procedure TDocument1C.AutoTimeAfterAP;
begin
  FObj.(Unassigned);
end;

// ()
procedure TDocument1C.AutoTimeBegOfDay;
begin
  FObj.(Unassigned);
end;

// ()
procedure TDocument1C.AutoTimeCurrent;
begin
  FObj.(Unassigned);
end;

// ()
procedure TDocument1C.AutoTimeEndOfDay;
begin
  FObj.(Unassigned);
end;

// ()
procedure TDocument1C.AutoTimeOff;
begin
  FObj.(Unassigned);
end;

// (<>)
function TDocument1C.BackwardOrder(ARegime: Variant): Boolean;
begin
  Result := Boolean(FObj.(OleVariant(ARegime)));
end;

// ()
procedure TDocument1C.ClearDeleteMark;
begin
  FObj.(Unassigned);
end;

// ()
function TDocument1C.CompareWithAP: Integer;
begin
  Result := Integer(FObj.(Unassigned));
end;

//    - 
//   /  OLE-
//      !
procedure TDocument1C.ConnectEvent;
begin
  //     
  if Assigned(Configuration) and Configuration.Connected then begin
    // ...    ,   
    if VarIsEmpty(FObj) then
      FObj := CreateObj;
  end else begin
    //  - 
    FObj := Unassigned;
  end;
end;

// 
constructor TDocument1C.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  //  properties
  FObj := Unassigned;
  FObjName := '';
end;

//   1-
function TDocument1C.CreateObj: Variant;
var
  FullObjName: String;
begin
  try
    FullObjName := '';
    if ObjName <> '' then
      FullObjName := FullObjName + '.' + ObjName;
    Result := Configuration.CreateObject(FullObjName);
  except
    MessageDlg('    "' + FullObjName + '"!',
      mtError, [mbOK], 0);
  end;
end;

// ()
function TDocument1C.CurrentDocument: Variant;
begin
  Result := FObj.(Unassigned);
end;

// (<>)
procedure TDocument1C.Delete(ARegime: Variant);
begin
  FObj.(OleVariant(ARegime));
end;

// ()
procedure TDocument1C.DeleteLine;
begin
  FObj.(Unassigned);
end;

// ()
procedure TDocument1C.DeleteLines;
begin
  FObj.(Unassigned);
end;

// ()
function TDocument1C.DeleteMark: Boolean;
begin
  Result := Boolean(FObj.(Unassigned));
end;

// (<>,<>,<>)
function TDocument1C.FindByNum(ANum: Variant; ADate: Variant;
  AKindName: Variant): Boolean;
begin
  Result := Boolean(FObj.(OleVariant(ANum),
    OleVariant(ADate), OleVariant(AKindName)));
end;

// (<>)
function TDocument1C.FindDocument(ADocument: Variant): Boolean;
begin
  Result := Boolean(FObj.(OleVariant(ADocument)));
end;

// (<>)
function TDocument1C.GetAttribute(AAttributeName: String): Variant;
begin
  Result := FObj.(OleVariant(AAttributeName));
end;

function TDocument1C.GetAttributesValue(const AAttributeName: String): Variant;
begin
  Result := FObj.(OleVariant(AAttributeName));
end;

// ()
function TDocument1C.GetDocument: Boolean;
begin
  Result := Boolean(FObj.(Unassigned));
end;

// ()
function TDocument1C.GetLine: Boolean;
begin
  Result := Boolean(FObj.(Unassigned));
end;

// (<>)
function TDocument1C.GetLineByNum(ANum: Integer): Boolean;
begin
  Result := Boolean(FObj.(OleVariant(ANum)));
end;

// ()
function TDocument1C.GetPosition: Variant;
begin
  Result := FObj.(Unassigned);
end;

// (<>,<>,<>)
function TDocument1C.GetTime(var AHour, AMin, ASec: Integer): String;
begin
  Result := FObj.(Unassigned, Unassigned, Unassigned);
  try
    AHour := StrToInt(Copy(Result, 1, 2));
    AMin := StrToInt(Copy(Result, 4, 2));
    ASec := StrToInt(Copy(Result, 7, 2));
  except
    AHour := 0; AMin := 0; ASec := 0;
  end;
end;

// ()
function TDocument1C.IsTransacted: Boolean;
begin
  Result := Boolean(FObj.(Unassigned));
end;

// ()
function TDocument1C.Kind: String;
begin
  Result := FObj.(Unassigned);
end;

// ()
function TDocument1C.LinesCnt: Integer;
begin
  Result := FObj.(Unassigned);
end;

// (<>,<>)
procedure TDocument1C.MakeActions(ARegime, AValue: Variant);
begin
  FObj.(OleVariant(ARegime), OleVariant(AValue));
end;

// ()
procedure TDocument1C.New;
begin
  FObj.(Unassigned);
end;

// ()
procedure TDocument1C.NewLine;
begin
  FObj.(Unassigned);
end;

// (<>)
function TDocument1C.NumPrefix(APrefix: String): String;
begin
  Result := FObj.(OleVariant(APrefix));
end;

// (<>)
function TDocument1C.OperExist(AExist: Variant): Boolean;
begin
  Result := Boolean(FObj.(OleVariant(AExist)));
end;

// (<>,<>,<>)
function TDocument1C.SelectByNum(ANum: Variant; ADate: Variant;
  AKindName: Variant): Boolean;
begin
  Result := Boolean(FObj.(OleVariant(ANum),
    OleVariant(ADate), OleVariant(AKindName)));
end;

// (<1>,<2>,<>)
function TDocument1C.SelectBySucc(ADate1, ADate2: Variant;
  ASuccName: String): Boolean;
begin
  Result := Boolean(FObj.(OleVariant(ADate1),
    OleVariant(ADate2), OleVariant(ASuccName)));
end;

// (<1>,<2>,<>,<>)
function TDocument1C.SelectByValue(ADate1, ADate2: Variant;
  ASelectionName: String; AValue: Variant): Boolean;
begin
  Result := Boolean(FObj.(OleVariant(ADate1),
    OleVariant(ADate2), OleVariant(ASelectionName),
    OleVariant(AValue)));
end;

// (<1>,<2>,<>)
function TDocument1C.SelectChildDocs(ADate1,
  ADate2, ADocument: Variant): Boolean;
begin
  Result := Boolean(FObj.(OleVariant(ADate1),
    OleVariant(ADate2), OleVariant(ADocument)));
end;

// (<1>,<2>)
function TDocument1C.SelectDocuments(ADate1, ADate2: Variant): Boolean;
begin
  Result := Boolean(FObj.(OleVariant(ADate1),
    OleVariant(ADate2)));
end;

// ()
function TDocument1C.Selected: Boolean;
begin
  Result := Boolean(FObj.(Unassigned));
end;

// ()
function TDocument1C.SelectLines: Boolean;
begin
  Result := Boolean(FObj.(Unassigned));
end;

// (<>,<>)
procedure TDocument1C.SetAttribute(AAttributeName: String;
  AValue: Variant);
begin
  FObj.(OleVariant(AAttributeName),
    OleVariant(AValue));
end;

procedure TDocument1C.SetAttributesValue(const AAttributeName: String;
  const AValue: Variant);
begin
  FObj.(OleVariant(AAttributeName),
    OleVariant(AValue));
end;

// (<>,<>,
//   <>,<>,<>,<>)
function TDocument1C.SetFilter(ATransacted, ANoTransacted, AWithoutSigns,
  AOperative, ACalculate, ABookKeeping: Integer): Boolean;
begin
  Result := Boolean(FObj.(OleVariant(ATransacted),
    OleVariant(ANoTransacted), OleVariant(AWithoutSigns),
    OleVariant(AOperative), OleVariant(ACalculate),
    OleVariant(ABookKeeping)));
end;

// (<>)
procedure TDocument1C.SetNewNum(APrefix: String);
begin
  FObj.(OleVariant(APrefix));
end;

procedure TDocument1C.SetObjName(const AValue: String);
begin
  if FObjName <> AValue then begin
    FObjName := AValue;
    //     
    if Assigned(Configuration) and Configuration.Connected then
      //   
      FObj := CreateObj
    else
      //  - 
      FObj := Unassigned;
  end;
end;

// (<>,<>,<>)
procedure TDocument1C.SetTime(AHour, AMin, ASec: Integer);
begin
  FObj.(OleVariant(AHour), OleVariant(AMin),
    OleVariant(ASec));
end;

// (<>,<>,<>,<>)
procedure TDocument1C.SetType(AAttributeName, ATypeName: String; ALength,
  APrecision: Variant);
begin
  FObj.(OleVariant(AAttributeName),
    OleVariant(ATypeName), OleVariant(ALength),
    OleVariant(APrecision));
end;

// (<>)
procedure TDocument1C.SortLines(AColumns: String);
begin
  FObj.(OleVariant(AColumns));
end;

// (<>)
function TDocument1C.Total(AAttributeName: String): Double;
begin
  Result := FObj.(OleVariant(AAttributeName));
end;

// ()
procedure TDocument1C.UnPost;
begin
  FObj.(Unassigned);
end;

// ()
function TDocument1C.UserKind: String;
begin
  Result := FObj.(Unassigned);
end;

// ()
procedure TDocument1C.Write;
begin
  FObj.(Unassigned);
end;

end.
 